IF  NOT EXISTS( select * from sys.columns where Name = N'IncrementQuestion' and Object_ID = Object_ID(N'Quota'))
BEGIN
	ALTER TABLE [Quota] ADD [IncrementQuestion] nvarchar(32)
END
GO

IF  NOT EXISTS( select * from sys.columns where Name = N'IncrementValue' and Object_ID = Object_ID(N'Stratum'))
BEGIN
	ALTER TABLE [Stratum] ADD [IncrementValue] int not null CONSTRAINT DF_Stratum_IncrementValue DEFAULT 1
END
GO


-- ************************************
-- Sp_respondentconnectquotas
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentconnectquotas]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_respondentconnectquotas]
GO

CREATE PROCEDURE [dbo].[Sp_respondentconnectquotas]
                @ProjectId  INT,
                @Respondent VARCHAR(10),
                @Action     INT
AS

	IF ( @Action = 3 )
	BEGIN
		-- Reset QTOnline
		UPDATE Quota SET  QtOnline = 0
	END
	ELSE
	BEGIN
		-- define the operation direction
		DECLARE  @Modifier INT
		IF ( @Action = 1 )
			SET @Modifier = 1
		ELSE If ( @Action = 2 )
			SET @Modifier = -1
		
		--Increment or Decrement  Quota.QtOnLine for strata that the respondent belong
		UPDATE Quota 
		SET  Quota.QtOnLine = Quota.QtOnLine + ( @Modifier * COALESCE(IncrementValue,1) ) 
		FROM Quota 
			inner join Stratum WITH (NOLOCK) on Quota.QtQuotaId = Stratum.StrQuotaId
		WHERE StrRespondent = @Respondent  
			  and Quota.QtStratum > 0
			  and Stratum.IncrementValue <> 0 
	END
GO





-- ************************************
-- sp_RespondentIncDecQuota
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_RespondentIncDecQuota]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_RespondentIncDecQuota]
GO

CREATE PROCEDURE [dbo].[sp_RespondentIncDecQuota]
                @ProjectId  INT,
                @userId     INT,
                @Respondent VARCHAR(10),
                @operation  BIT
AS

-- define the operation direction
DECLARE  @CNT INT
IF @operation = 1
SET @CNT = 1
ELSE
SET @CNT = -1


--Update the quotas frequency for the specified Respondent
UPDATE quota
SET    quota.qtfrequence = quota.qtfrequence + (@CNT*COALESCE(IncrementValue,1))
FROM   stratum  WITH (nolock) 
			inner join  quota  WITH (nolock) on stratum.StrQuotaId = quota.QtQuotaId
WHERE stratum.StrQuotaId = quota.QtQuotaId
      and stratum.strrespondent = @Respondent
      and stratum.IncrementValue <> 0


--Update Master Quota frequency
UPDATE quota
SET    quota.qtfrequence = quota.qtfrequence + @CNT
FROM   quota 
WHERE  qtstratum = 0

-- Update Frequency for Agent (table QuotasAgent) 
UPDATE QuotasAgent
SET    Frequency = Frequency + (@CNT*COALESCE(IncrementValue,1))
FROM   Stratum  WITH (nolock),  QuotasAgent 
WHERE	Stratum.StrQuotaId = QuotasAgent.QuotaId
		AND Stratum.StrRespondent = @Respondent 
		AND QuotasAgent.AgentId=@userId 



    IF @CNT = 1
    BEGIN
      -- Define if quota are active
      DECLARE  @UseQuotas BIT
      SET @UseQuotas = (SELECT TOP 1 insvalue FROM   installation WHERE  inssection = 'QUOTAS' AND insident = 'QUOTASACTIFS')
      IF @UseQuotas IS NULL
        SET @UseQuotas = 0
      
      
      IF @UseQuotas = 1
        BEGIN
          DECLARE  @NonClosedStrata INT
          --  Create a list of strat to close for this respondent
          SELECT StrQuotaId
          INTO   #closingstrata
          FROM   stratum
                 INNER JOIN quota
                   ON quota.QtQuotaId = Stratum.StrQuotaId
                      AND qtquota > 0
                      AND qtfrequence >= qtquota
                      AND qtstatus <> 2
          WHERE  strrespondent = @respondent
                 AND strstratum > 0
          
          -- count the amount of strat to close
          SELECT @NonClosedStrata = Count(StrQuotaId) FROM   #closingstrata
          
          IF @NonClosedStrata > 0
            BEGIN
              
              -- Call UPdateStrataState 
              EXEC sp_UpdateStrataState  @projectId ,   @userId
              
              -- blocked the respondents that are parts of a closed strata
              UPDATE respondent
              SET    resblocked = 1,
                     projectid = @projectId,
                     modifiedby = @userId,
                     modified = Getutcdate()
              WHERE  resrespondent IN (SELECT strrespondent
                                       FROM   stratum
                                       WHERE  StrQuotaId IN (SELECT StrQuotaId
                                                             FROM   #closingstrata))
            END
        END
    END
GO


-- ************************************
-- Sp_recomputequotacounters
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_recomputequotacounters]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_recomputequotacounters]
GO



CREATE PROCEDURE  [dbo].[Sp_recomputequotacounters]
    @projectId INT,
    @UserId    INT,
    @ImportWave INT = null
AS
  
--Read installation config and get QUOTASMODEREPLICATE flag
DECLARE  @replicate BIT
SELECT @replicate = insvalue   FROM   Installation   WHERE  insident = 'QUOTASMODEREPLICATE'

--Update Quota counters
IF @replicate = 1
BEGIN
UPDATE Quota
SET    QtUnused		= [Unused],
       QtFrequence	= [Completed],
       QtOnline		= [Online]
FROM   Quota INNER JOIN 
 (SELECT QuotaId,
             Sum([unused])    AS [unused],
             Sum([completed]) AS [completed],
             Sum([online])    AS [online]
         FROM (SELECT QtQuotaId AS QuotaId,
                 CASE WHEN ResCall = 0         THEN COALESCE(IncrementValue,1) ELSE 0 END AS [Unused],
                 CASE WHEN ResCompleted = 1    THEN COALESCE(IncrementValue,1) ELSE 0 END AS [Completed],
                 CASE WHEN ResCallBackDate > 0 THEN COALESCE(IncrementValue,1) ELSE 0 END AS [Online]
              FROM Quota
                   LEFT OUTER JOIN Stratum    WITH (NOLOCK) ON QtQuotaId = StrQuotaId
                   LEFT OUTER JOIN respondent WITH (NOLOCK) ON StrRespondent = ResRespondent
              WHERE  QtStratum > 0) a
         GROUP BY QuotaId) b ON QuotaId = QtQuotaId
END
ELSE
BEGIN
	UPDATE Quota
	SET	   QtUnused	= isnull( unused.cnt,0 ),
		   QtFrequence = isnull( completed.cnt,0 ),
		   QtOnLine	= 0
	FROM Quota
		left join ( SELECT StrQuotaId QuotaId, SUM(COALESCE(IncrementValue,1) ) as cnt 
					FROM Stratum WITH(nolock) 
						inner join Respondent WITH(nolock) on StrRespondent = ResRespondent 
					WHERE ResCall = 0 
					GROUP BY StrQuotaId ) unused on QtQuotaId = unused.QuotaId 
		left join ( SELECT StrQuotaId QuotaId, SUM(COALESCE(IncrementValue,1) ) as cnt 
					FROM Stratum WITH(nolock) 
						inner join Respondent WITH(nolock) on StrRespondent = ResRespondent 
					WHERE ResCompleted = 1 
					GROUP BY StrQuotaId) completed on QtQuotaId = completed.QuotaId 
	WHERE QtStratum > 0 --Exclude global quota
END

--Update Respondent ResIntervCall with Group
UPDATE Respondent
SET  ResIntervCall = (CASE WHEN qtgroup = 0 THEN '' 
						   WHEN qtgroup < 10 THEN 'G0' + Cast(qtgroup AS VARCHAR) 
						   ELSE 'G' + Cast(qtgroup AS VARCHAR) END ) 
FROM Respondent 
inner join (SELECT StrRespondent as respondent, MAX(qtgroup) qtgroup 
			FROM Stratum WITH (NOLOCK) 
				inner join Quota WITH (NOLOCK) on StrQuotaid = QtQuotaId 
			GROUP BY StrRespondent) qt on ResRespondent = qt.respondent
WHERE	ResCall = 0
		and (@importWave is null or @ImportWave = ResWaveImportNo)
		and (ResIntervCall = '' OR ResIntervCall = '***' OR ResIntervCall LIKE 'G[0-9][0-9]')
		and  ResIntervCall <> ( CASE WHEN qtgroup = 0  THEN '' 
			  				    WHEN qtgroup < 10 THEN 'G0' + Cast(qtgroup AS VARCHAR) 
							    ELSE 'G' + Cast(qtgroup AS VARCHAR) END )

--Update Global Quota QtUnused and QtFrequence
UPDATE Quota
SET	QtUnused	= ( SELECT Count(resrespondent) FROM Respondent WITH (NOLOCK) WHERE ResCall = 0 ),
	QtFrequence = ( SELECT Count(resrespondent) FROM Respondent WITH (NOLOCK) WHERE  rescompleted = 1 )
WHERE QtStratum = 0


--Update frequency for quotasagent (CAPI)
UPDATE quotasagent 
SET  frequency=completed 
FROM QuotasAgent inner join
	 ( SELECT Stratumno,interviewerid, sum(completed) as completed 
	   FROM ( SELECT Stratum as Stratumno,
					agentid as interviewerid, 
					COALESCE(IncrementValue,1) as completed 
              FROM QuotasAgent WITH (NOLOCK)
				left outer join quota	WITH (NOLOCK)	   on  qtstratum = stratum 
				left outer join stratum	WITH (NOLOCK)	   on  stratum = strstratum 
				left outer join respondent r WITH (NOLOCK) on  strrespondent = resrespondent 
																and IsNumeric(resintervcall) = 1 
																and resintervcall = agentid
																and resCompleted = 1 ) a 
	   GROUP BY stratumno, interviewerid ) b   on  stratum=stratumno  and agentid=interviewerid
GO



-- ************************************
-- sp_RecomputeQuotaCountersWithoutOnlineReset
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset]
GO

CREATE PROCEDURE [dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset] 
	@projectId  int  ,
	@UserId int 
AS

--Get the replicate option from installation table
declare @replicate bit 
select @replicate=InsValue from installation where insident = 'QUOTASMODEREPLICATE' 


IF @replicate=1 
BEGIN 
	UPDATE Quota 
	SET	qtunused=unused, 
		qtfrequence=completed, 
		qtonline=online 
	FROM Quota 
	inner join (	SELECT	stratum, 
							sum(unused) as unused, 
							sum(completed) as completed, 
							sum(online) as online 
					FROM 
						(	SELECT	qtstratum as stratum, 
									case when rescall=0			then COALESCE(IncrementValue,1) else 0 end as unused, 
									case when rescompleted=1	then COALESCE(IncrementValue,1) else 0 end as completed, 
									case when rescallbackdate>0 then COALESCE(IncrementValue,1) else 0 end as online 
							FROM quota 
								left outer join stratum WITH (NOLOCK) on Quota.QtQuotaId = Stratum.StrQuotaId
								left outer join respondent WITH (NOLOCK) on strrespondent=resrespondent 
							WHERE qtstratum > 0 ) a 
					GROUP BY stratum ) b on stratum=qtstratum 
END
ELSE 
BEGIN 
	UPDATE Quota 
	SET		qtunused=unused, 
			qtfrequence=completed 
	FROM Quota 
		inner join (	SELECT	stratum, 
								sum(unused) as unused, 
								sum(completed) as completed 
						FROM 
							(	SELECT	qtstratum as stratum, 
										case when rescall=0			then COALESCE(IncrementValue,1) else 0 end as unused, 
										case when rescompleted=1	then COALESCE(IncrementValue,1) else 0 end as completed 
								FROM quota 
									left outer join stratum WITH (NOLOCK) on Quota.QtQuotaId= Stratum.StrQuotaId
									left outer join respondent  WITH (NOLOCK) on strrespondent=resrespondent 
								WHERE qtstratum > 0 ) a 
						GROUP BY stratum ) b on stratum=qtstratum 
END



UPDATE respondent 
SET resintervcall=newintervcall 
FROM respondent 
		inner join (	SELECT	respondent, 
								case 
									when qtgroup=0 then '' 
									when qtgroup < 10 then 'G0' + cast(qtgroup as varchar) 
									else 'G'+cast (qtgroup as varchar) end as newintervcall 
						FROM
							(	SELECT	resrespondent as respondent, 
										max(qtgroup) as qtgroup 
								FROM
									(	SELECT	resrespondent, 
												qtgroup 
										FROM quota 
											inner join stratum on Stratum.StrQuotaId=Quota.QtQuotaId
											inner join (	SELECT resrespondent 
															from respondent where rescall=0 and (resintervcall='' or resintervcall='***' or resintervcall like 'G[0-9][0-9]') ) a on resrespondent = strrespondent ) b group by resrespondent ) c ) d on resrespondent = respondent 

-- Update Global Quota
UPDATE  Quota 
SET		qtunused	=	( select count(resrespondent) from respondent  WITH (NOLOCK) where rescall=0 ),
		qtfrequence	=	( select count(resrespondent) from respondent  WITH (NOLOCK) where rescompleted=1 ) 
WHERE qtstratum=0

--Update frequency for quotasagent (CAPI)
UPDATE	quotasagent
SET	frequency=completed
FROM quotasagent
	inner join (	SELECT	stratumno,
							interviewerid, 
							sum(completed) as completed 
					FROM 
						(	SELECT	stratum as stratumno,
									agentid as interviewerid, 
									case when rescompleted=1 then COALESCE(IncrementValue,1) else 0 end as completed 
							FROM quotasagent 
								left outer join quota WITH (NOLOCK) on qtstratum = stratum 
								left outer join stratum WITH (NOLOCK) on  stratum=strstratum 
								left outer join respondent WITH (NOLOCK) on strrespondent=resrespondent 
																			and IsNumeric(resintervcall)=1 
																			and resintervcall=agentid
						) a 
					GROUP BY stratumno,interviewerid ) b on stratum=stratumno and agentid=interviewerid
GO



-- ************************************
-- Sp_respondentincdecunused
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentincdecunused]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_respondentincdecunused]
GO


CREATE PROCEDURE [dbo].[Sp_respondentincdecunused]
                @ProjectId  INT,
                @userId     INT,
                @Respondent VARCHAR(10),
                @operation  BIT
AS
  
--Set the Operation Direction
DECLARE  @CNT INT
IF @operation = 1
      SET @CNT = 1
ELSE
      SET @CNT = -1

  
-- Update unused for the respondent stratum
UPDATE Quota
SET    QtUnused = CASE WHEN ( ( Quota.QtUnused + ( @CNT * COALESCE(IncrementValue,1) ) ) < 0 )
                              THEN 0 
                              ELSE ( Quota.QtUnused + ( @CNT * COALESCE(IncrementValue,1) ) ) END
FROM   Quota  
                  inner join Stratum WITH (nolock)
                        on Quota.QtQuotaId = Stratum.StrQuotaId
WHERE   Stratum.strrespondent = @Respondent
 
-- Update the Main unused
UPDATE Quota
SET    qtunused = CASE	WHEN ( qtunused + @CNT < 0 )
						THEN 0
						ELSE (qtunused + @CNT) END
WHERE  qtstratum = 0
GO


---  
---  SP_NEW START
---
---Modified 2010-03-24: ReAdded the Location='Server' filter 
---Modified 2010-07-02: Enabled the pronto option :  Use Do Not Call list
---Modified 2010-12-01: Performance using tempdb
---Modified 2011-07-20: Added dialing mode. Renamed
---Modified 2011-11-18: Support for TimeSlot Counters
---Modified 2011-12-15: Weight applies to Callbacks
---Modified 2012-01-12: RoleSets
---Modified 2012-07-09: Change the nature of ResTimeSlot
---Modified 2012-09-18: Exclude assigned cases when in Role mode
---Modified 2012-11-02: Fix for Half opened
---Modified 2013-04-22: Fix for Half opened (2)
---Modified 2013-07-11: Fix for blocking of extraction in ServNo
---Modified 2013-09-13: Added Tracing
---Modified 2013-10-28: Added Tracing info; Performance modification for #excludedRespondent
---Modified 2014-01-28: Quota by question support for Half Open
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_FillCaseBuffer]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_FillCaseBuffer]
GO

CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBuffer]  
	@BrowseNbr int = 100, -- Should use f(NbrLoggedAgents)
	@ProjectId int = 0, -- Normally ignored
	@DialingMask int = 0xFF, -- Bit: NA,NA,NA,NA,NA,PV,NP,PR 
	@ClearBuffer bit = 1, -- 1 -> clear and fill; 0 -> append to buffer
	@GroupNbr int = 0 , -- Default 0, ignored for project Roles
	@RoleSets varchar(max) = null, -- '1,2,3;1,4;1,2,4' ',' -> seperates roles, ';' seperates roleset belonging to same group/agent
	@TraceInfo varchar(max) = null,
	@TraceId bigint = null OUT
AS
	-- version Sept 2013
	DECLARE @RequestedCases int, @ExcludedCases bigint, @HalfOpenExcess int, @TotalExtractedCases int
	SET @RequestedCases = @BrowseNbr;

	DECLARE @StartTStamp DateTime
	SET @StartTStamp = getutcdate();

	DECLARE @isPreviewSupported bit
	SET @isPreviewSupported = (@DialingMask & 0x4) --3rd bit from right says module does Preview dial

	--Get configuration information
	DECLARE @UseSmoothing bit
	SET @UseSmoothing= (SELECT TOP 1 INSVALUE FROM Installation WHERE INSSECTION='QUOTAS' and INSIDENT='QUOTASSMOOTH')
	IF (@UseSmoothing IS NULL) SET @UseSmoothing=0
	
	DECLARE @UseQuotas bit
	SET @UseQuotas = (SELECT TOP 1 INSVALUE FROM Installation  WHERE INSSECTION='QUOTAS' and INSIDENT='QUOTASACTIFS')
	IF (@UseQuotas is NULL) SET @UseQuotas = 0

	DECLARE @Replicate bit
	SET @Replicate = (SELECT TOP 1 coalesce(INSVALUE,0) From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTASMODEREPLICATE')
	IF (@Replicate is NULL) SET @Replicate = 0
	
	DECLARE @dncFlag bit
	SET @dncFlag= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNC')
	IF (@dncFlag IS NULL) SET @dncFlag = 1
	
	DECLARE @FreshPriority int
	SET @FreshPriority = (Select top 1 INSVALUE From Installation where INSSECTION='RULES' and INSIDENT='PRIORITY OF FRESH')
	IF (@FreshPriority IS NULL) SET @FreshPriority = 0

	--Clear previous case buffer for group
	IF @ClearBuffer = 1 DELETE FROM dbo.BufferNew WHERE intgroup = @GroupNbr

	--Disable tracing
	SET NOCOUNT ON

	--Compile TimeSlots hit by each TimeZones   
	CREATE TABLE #tzts (timezone int,timeslot int)
	INSERT INTO #tzts
	SELECT id+0 as timezone,dbo.TimeSlotNumber(DateAdd(mi,(gmtbias + dstbias*dstactive)*60,GetUTCDATE())) as timeslot
	FROM dbo.TimeZones
	UNION SELECT 0,dbo.TimeSlotNumber(GetUTCDate())

	--Compile list of invalid respondent (timeslot limit reached, closed stratum)
	CREATE TABLE #excludedRespondent(respondent varchar(10) primary key) -- List of respondent invalid (TimeSlot / Closed Quotas)
	INSERT INTO #excludedRespondent
	SELECT ResRespondent -- Add respondent that are hit by the current TimeSlot
	FROM Respondent with(nolock)
		inner join TimeSlotHit with(nolock) on TimeSlotHit.TshRespondent = Respondent.ResRespondent
		inner join #tzts on #tzts.timeslot = TimeSlotHit.TshTimeSlot and #tzts.timezone = Respondent.ResTimeZone 
		inner join TimeSlot with(nolock) on TimeSlotHit.TshTimeSlot = TimeSlot.TslNumber
		left join TimeSlotCounter with(nolock) on TimeSlot.TslNumber = TimeSlotCounter.TslNumber and Respondent.IntLevel = TimeSlotCounter.RespondentLevel
	WHERE ResTimeSlot <> 0 
		and TimeSlotHit.[Counter] >= isnull(TimeSlotCounter.MaxCounter, TimeSlot.MaxCounter) -- Only exlude respondent whose reached the max for the timeslot
	UNION -- UNION instead of UNION ALL for better performance filtering the BufferNew inserts
	SELECT StrRespondent -- Add respondent that are part of a closed quota
	FROM Stratum with(nolock)
		inner join Quota with(nolock) on QtStratum = StrStratum
	WHERE QtStatusTemp = 2 -- Closed strata
	SET @ExcludedCases = @@RowCount --May include double counting
	
	--ReEnable tracing
	SET NOCOUNT OFF

	--Get stratum information
	DECLARE @NbrWeights int-- Number of Stratum with Weights
	SET @NbrWeights = 0
	if @Replicate <> 1 -- Weights and Replicates are not compatible : ignore the weights
		SELECT @NbrWeights = Count(QtStratum) FROM Quota with(nolock) 
		WHERE QtWeight >0 and QtStatusTemp<>2 AND QtUnused > 0 and (QtGroup=@GroupNbr or QtGroup=0)
	
	DECLARE @SumRemaining int
	SET @SumRemaining = 0	
	if @UseSmoothing = 1
		SELECT @SumRemaining = SUM(QtQuota - QtFrequence) FROM Quota with(nolock)
		WHERE QtStratum <> 0 and (qtgroup=@GroupNbr or qtGroup=0) and QtWeight <> 0 and QtQuota > 0 and QtStatus < 2

	--Get Project mode (GROUP or ROLESET)
	IF NOT EXISTS (SELECT 1 FROM tblPages WHERE kind = 12000 and name = 'SAMPLEASSIGNMENTMODE' and StaticValue = 'ROLE'	and k_id = 
		(SELECT k_id FROM tblPages WHERE Kind = 12000 and Name = 'InterviewerProjectId' and ('Voxco_Project_' + StaticValue = DB_NAME())))
	BEGIN --Group mode
	
		--Evaluate group string
		DECLARE @StrGroup char(3)
		SET @StrGroup = 'G' + right('0'+ convert(varchar(2),@groupnbr),2) --35% faster than with a if + length

		if @replicate = 0 
		begin
			if @NbrWeights = 0 
			begin

				-- general : no weights - no replicates
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE 
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Res.Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					-- Role not evaluated
					/*Variable criterion*/
					and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
				ORDER BY ResPriority desc, (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), ResSeed
				SET @TotalExtractedCases = @@RowCount

			end
			else if @UseSmoothing = 0
			begin
      
				-- weight distribution without smoothing
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join Stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						-- Role not evaluated
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount
			
			end
			else --if @UseSmoothing = 1
			begin

				-- smoothing weight distribution
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						-- Role not evaluated
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --!!!Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount
      
			end	
		end
		else --if @replicate = 1
		begin

			-- replicates
			-- 1: call-backs with high priority - regardless of statustemp
			INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
			SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
			FROM Respondent Res with(nolock)
			WHERE
				/*Invariable criterion (should be same for every query in this SP */
				(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
				and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
				and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
				and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
				and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
				and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
				and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
				-- Role not evaluated
				/*Variable criterion*/
				and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and	(resPriority >= @FreshPriority)
			ORDER BY ResPriority desc, rescallbackdate, ResSeed
			SET @TotalExtractedCases = @@RowCount
		
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 2 : fresh cases -- one at a time for replicates with statustemp <> 2
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					-- Role not evaluated
					/*Variable criterion*/
					and (ResCall=0) and (resPriority>= @freshPriority )
				ORDER BY ResPriority desc, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount

			end
	     
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 3 : call-backs with low priority - regardless of statusTemp
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					-- Role not evaluated
					/*Variable criterion*/
					and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
					and	(resPriority < @freshPriority)
				ORDER BY ResPriority desc, rescallbackdate, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
			end
		end

	END ELSE BEGIN --Role mode
			
		-- Split supported roles
		SELECT RoleSet.Value RoleSet, convert(int, [Role].Value) [Role]
		INTO #SupportedRole
		FROM fn_cte_splitstring(@RoleSets, ';') RoleSet
			cross apply fn_cte_splitstring(RoleSet.Value, ',') [Role]

		if @replicate = 0 
		begin
			if @NbrWeights = 0 
			begin

				-- general : no weights - no replicates
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE 
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Res.Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
						or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
							(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
							(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
					/*Variable criterion*/
					and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
				ORDER BY ResPriority desc, (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), ResSeed
				SET @TotalExtractedCases = @@RowCount
	      
			end
			else if @UseSmoothing = 0
			begin
      
				-- weight distribution without smoothing
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join Stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
							or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
								(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
								(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount

			end
			else --if @UseSmoothing = 1
			begin

				-- smoothing weight distribution
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
							or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
								(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
								(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --!!!Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount
      
			end	
		end
		else --if @replicate = 1
		begin

			-- replicates
			-- 1: call-backs with high priority - regardless of statustemp
			INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
			SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
			FROM Respondent Res with(nolock)
			WHERE
				/*Invariable criterion (should be same for every query in this SP */
				(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
				and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
				and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
				and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
				and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
				and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
				and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
				and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
					or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
						(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
						(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
				/*Variable criterion*/
				and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and	(resPriority >= @FreshPriority)
			ORDER BY ResPriority desc, rescallbackdate, ResSeed
			SET @TotalExtractedCases = @@RowCount
		
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 2 : fresh cases -- one at a time for replicates with statustemp <> 2
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
						or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
							(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
							(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
					/*Variable criterion*/
					and (ResCall=0) and (resPriority>= @freshPriority )
				ORDER BY ResPriority desc, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
			end
	     
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 3 : call-backs with low priority - regardless of statusTemp
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
						or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
							(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
							(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
					/*Variable criterion*/
					and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
					and	(resPriority < @freshPriority)
				ORDER BY ResPriority desc, rescallbackdate, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
			end
		end

		DROP TABLE #SupportedRole
	END

	--Verify HalfOpen stratum
	SET @HalfOpenExcess = 0
	IF @Replicate <> 1 --HalfOpen not supported with Replicate
	BEGIN
		DECLARE @HOStratum int --Count of halfopen stratum
		DECLARE @IncrementStratum int --Count of stratum with increment question defined
		SELECT @HOStratum = SUM(case when QtStatus = 1 then 1 else 0 end),
			@IncrementStratum = SUM(case when IncrementQuestion <> '' then 1 else 0 end)
		FROM QUOTA with(nolock) WHERE ( QtGroup=0 or QtGroup=0) and QtQuota>0
	
		IF @HOStratum > 1 --HalfOpen stratum exists
		BEGIN
			IF @IncrementStratum = 0 --No stratum uses a IncrementQuestion setting
			BEGIN -- Delete Respondent that exceeds HalfOpen Quotas using optimal window row_number function
				DELETE FROM BufferNew
				WHERE EXISTS (
					SELECT Respondent
					FROM
					(SELECT Respondent Respondent,
						row_number() over (partition by QtQuotaId order by priority, callbackdate, seed) [rank],
						Qt.QtQuota - (QtFrequence + QtOnline) [max]
					FROM BufferNew 
						inner join Stratum with(nolock) on Respondent = StrRespondent
						inner join Quota Qt with(nolock) on StrQuotaId = Qt.QtQuotaId
					WHERE IntGroup = @GroupNbr and Qt.QtStatus = 1 and Qt.QtQuota>0) res
					WHERE [rank] > [max] and res.respondent = BufferNew.Respondent
				)
			END ELSE --At least one stratum with IncrementQuestion setting
			BEGIN -- Delete Respondent that exceeds HalfOpen Quotas using running sum evaluation
				-- Build a runningSum CTE
				WITH runningSum AS
				(
				SELECT Respondent Respondent, QuotaId, [max], [rank], IncrementValue RunningSum, 0 PreviousRunningSum
				FROM
					(SELECT Respondent Respondent, StrQuotaId QuotaId, 
						QtQuota - (QtFrequence + QtOnline) [max],
						row_number() over (partition by StrQuotaId order by priority, callbackdate, seed) [rank], IncrementValue
					 FROM BufferNew inner join Stratum with(nolock) inner join Quota with(nolock) on QtQuotaId = StrQuotaId on Respondent = StrRespondent 
					 WHERE IntGroup = 0 and QtStatus = 1 and QtQuota >0) a
				WHERE [rank] = 1 UNION ALL
				SELECT a.Respondent Respondent, a.QuotaId, runningSum.[max], a.[rank], (runningSum.RunningSum + a.IncrementValue) RunningSum, runningSum.RunningSum PreviousRunningSum
				FROM
					runningSum inner join 
					(SELECT Respondent Respondent, StrQuotaId QuotaId, 
						row_number() over (partition by StrQuotaId order by priority, callbackdate, seed) [rank], IncrementValue
					 FROM BufferNew inner join Stratum with(nolock) on Respondent = StrRespondent 
					 ) a on runningSum.QuotaId = a.QuotaId and runningSum.[rank]+1 = a.[rank]
				)

				-- Use the CTE to delete any cases that follow the case that would cause the stratum to close
				DELETE FROM BufferNew
				WHERE EXISTS (SELECT Respondent FROM runningSum WHERE PreviousRunningSum >= [max] and Respondent = BufferNew.Respondent)
			END

			SET @HalfOpenExcess = @@RowCount
			SET @TotalExtractedCases = @TotalExtractedCases - @HalfOpenExcess
		END
	END

	DROP TABLE #tzts
	DROP TABLE #excludedRespondent


	--Write a trace of the extraction
	SET NOCOUNT ON
	DECLARE @InsertedTrace table(TraceId bigint)
	INSERT INTO BufferTrace(Info,StartDate,EndDate,ApplicationName,ClientHostname,
		RequestedCases,DialingMask,ClearBuffer,GroupNbr,RoleSets,
		UseSmoothing,UseQuotas,[Replicate],DNCFlag,FreshPriority,WeightsCount,
		ExcludedCases,HalfOpenExcess,TotalExtractedCases)
	OUTPUT inserted.TraceId INTO @InsertedTrace
	VALUES (@TraceInfo,@StartTStamp,getutcdate(),APP_NAME(),HOST_NAME(),
		@RequestedCases,@DialingMask,@ClearBuffer,@GroupNbr,@RoleSets,
		@UseSmoothing,@UseQuotas,@Replicate,@dncFlag,@FreshPriority,@NbrWeights,
		@ExcludedCases,@HalfOpenExcess,@TotalExtractedCases)
	SELECT @TraceId = TraceId FROM @InsertedTrace  
	SET NOCOUNT OFF
GO




